<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVandorsTable extends Migration {

	public function up()
	{
		Schema::create('vandors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email')->unique();
			$table->string('name');
			$table->string('code');
			$table->string('password');
			$table->integer('country_id');
			$table->integer('city_id')->nullable();
			$table->integer('district_id')->nullable();
			$table->string('address')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->string('location_address')->nullable();
			$table->string('phone');
			$table->enum('type', array('public', 'academic', 'school', 'orprivate'));
			$table->string('license_number');
		});
	}

	public function down()
	{
		Schema::drop('vandors');
	}
}