<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('plan_type', array('User', 'CulturalEntity'));
			$table->string('name');
			$table->integer('price');
			$table->enum('duration', array('monthly', 'yearly'));
			$table->integer('plan_id');
			$table->morphs('owner');
			$table->boolean('is_active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}