<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSocialAccountsTable extends Migration {

	public function up()
	{
		Schema::create('social_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('provider_name')->unique();
			$table->integer('provider_id')->unique();
			$table->string('access_token')->nullable();
			$table->string('refresh_token')->nullable();
			$table->timestamp('token_expires_at')->nullable();
			$table->morphs('account');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('social_accounts');
	}
}