<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaperBookDetailsTable extends Migration {

	public function up()
	{
		Schema::create('paper_book_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('book_id')->unsigned();
			$table->enum('format', array(''));
			$table->enum('condition_type', array(''));
			$table->integer('quantity');
			$table->integer('price');
			$table->boolean('available')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('paper_book_details');
	}
}