<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFaqsTable extends Migration {

	public function up()
	{
		Schema::create('faqs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('category', array('Account', 'Payments', 'Technical'));
			$table->string('question');
			$table->text('answer');
			$table->boolean('is_active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('faqs');
	}
}