<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('code', array('Percentage', 'FixedAmount'));
			$table->integer('discount_value')->nullable();
			$table->integer('max_usage_limit');
			$table->integer('max_usage_per_user');
			$table->date('start_date');
			$table->date('end_date');
			$table->enum('applies', array('Orders', 'Subscription'));
			$table->integer('vendor_id')->nullable();
			$table->text('description')->nullable();
			$table->boolean('is_active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}