<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    public function socialAccounts()
    {
        return $this->hasOne('SocialAccount');
    }

    public function OTPTokens()
    {
        return $this->morphMany('AuthenticatableOtp')->latest();
    }

    public function approvalHistory()
    {
        return $this->hasMany('CultureApprovalHistrory');
    }

}