<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabServicesTable extends Migration {

	public function up()
	{
		Schema::create('tabServices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_provider_id')->unsigned();
			$table->string('avatar')->nullable();
			$table->string('title');
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabServices');
	}
}