<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabServiceProviderTable extends Migration {

	public function up()
	{
		Schema::create('tabServiceProvider', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->string('status', 10)->default('Active');
			$table->integer('city_id')->unsigned();
			$table->string('verified', 10)->default('No');
			$table->string('email_id');
			$table->string('contact_no');
			$table->string('website')->nullable();
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabServiceProvider');
	}
}