<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 245);
			$table->string('email', 245)->nullable();
			$table->string('country_code', 50)->default('91');
			$table->string('mobile', 125)->nullable();
			$table->string('user_name', 245)->nullable();
			$table->string('password', 245);
			$table->integer('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}