<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserFeatureUsageTable extends Migration {

	public function up()
	{
		Schema::create('user_feature_usage', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('plan_id')->unsigned();
			$table->integer('feature_id')->unsigned();
			$table->datetime('date');
			$table->integer('status')->default('1');
			$table->datetime('approved_on')->nullable();
			$table->integer('approved_by')->unsigned()->nullable();
			$table->datetime('rejected_on')->nullable();
			$table->integer('rejected_by')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_feature_usage');
	}
}