<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransferPlanTable extends Migration {

	public function up()
	{
		Schema::create('transfer_plan', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('transfer_user_id');
			$table->integer('plan_id')->unsigned();
			$table->integer('status')->default('0');
			$table->date('date');
			$table->integer('approved_by')->nullable();
			$table->datetime('approved_on')->nullable();
			$table->integer('rejected_by')->nullable();
			$table->datetime('rejected_on')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transfer_plan');
	}
}