<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanVendorsTable extends Migration {

	public function up()
	{
		Schema::create('plan_vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('plan_id')->unsigned();
			$table->integer('vendor_id')->unsigned();
			$table->string('title', 125);
			$table->text('description')->nullable();
			$table->integer('type')->default('1');
			$table->integer('max_count')->default('1');
			$table->string('voucher_file', 245)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('plan_vendors');
	}
}