<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChatMessagesTable extends Migration {

	public function up()
	{
		Schema::create('chat_messages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->unsigned()->nullable();
			$table->integer('receiver_id')->unsigned()->nullable();
			$table->integer('sender_id')->unsigned();
			$table->enum('content_type', array('text', 'emoji', 'image', 'file'));
			$table->string('content');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('chat_messages');
	}
}