<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChatGroupMessagesTable extends Migration {

	public function up()
	{
		Schema::create('chat_group_messages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('chat_group_id')->unsigned();
			$table->integer('parent_id')->unsigned();
			$table->integer('sender_id')->unsigned();
			$table->enum('content_type', array('text', 'emoji', 'image', 'file'));
			$table->string('content');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('chat_group_messages');
	}
}