<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function givenLikes()
	{
		return $this->hasMany('Fotolike');
	}

	public function role()
	{
		return $this->belongsTo('Role');
	}

	public function comments()
	{
		return $this->hasMany('Comment');
	}

	public function fotos()
	{
		return $this->hasMany('Foto');
	}

}