<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'dob', 'address', 'email', 'contact_number', 'guardian_name', 'gurdian_phone_number', 'guardian_email', 'password', 'image', 'qualification', 'blood_type', 'gender', 'roles');
	protected $hidden = array('password');

	public function attend()
	{
		return $this->hasMany('Attendence', 'id');
	}

	public function enroll()
	{
		return $this->hasMany('Enrollment', 'id');
	}

	public function file()
	{
		return $this->hasMany('File', 'id');
	}

	public function teacher()
	{
		return $this->belongsToMany('Teacher_assign', 'id');
	}

}