<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CampaignRequest extends Model 
{

    protected $table = 'campaign_requests';
    public $timestamps = true;
    protected $fillable = array('business_id', 'campaign_id', 'influencer_id', 'requested_type', 'payment_details', 'payment_status');
    protected $visible = array('business_id', 'campaign_id', 'influencer_id', 'requested_type', 'payment_details', 'payment_status');

    public function campaign()
    {
        return $this->belongsTo('Campaign');
    }

    public function influencer()
    {
        return $this->hasOne('Influencer');
    }

    public function business()
    {
        return $this->hasOne('Business');
    }

}