<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('description', 191);
			$table->string('phone', 191);
			$table->boolean('allow_shipping')->default(0);
			$table->integer('admin_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}