<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesOrdersTable extends Migration {

	public function up()
	{
		Schema::create('sales_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code')->unique();
			$table->integer('buyers_id')->unsigned();
			$table->integer('payment_terms_id')->unsigned();
			$table->timestamp('issued');
			$table->timestamp('duedate');
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('sales_orders');
	}
}