<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutcomeItemsTable extends Migration {

	public function up()
	{
		Schema::create('outcome_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->timestamp('received_at');
			$table->enum('ref', array('purchase', 'return', 'tags'));
			$table->integer('ref_id');
			$table->integer('financial_storages_id')->unsigned();
			$table->double('amount');
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('outcome_items');
	}
}