<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('references', 100)->default('reference');
			$table->string('designation', 100)->default('0');
			$table->text('description')->default('0');
			$table->float('prix_vente')->default('0');
			$table->float('qte_stock')->default('0');
			$table->float('qte_alert')->default('0');
			$table->string('photo');
			$table->integer('sous_categories_id')->unsigned()->default('1');
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}