<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Feedback extends Model 
{

    protected $table = 'feedback';
    public $timestamps = true;

    public function penilaianAtasan()
    {
        return $this->belongsTo('App\PenilaianAtasan', 'penilaian_atasan_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo('App\User', 'nip_pegawai', 'nip');
    }

    public function feedbackBawahan()
    {
        return $this->hasMany('App\FeedbackBawahan', 'feedback_id', 'id');
    }

    public function jadwalLiquid()
    {
        return $this->belongsTo('App\JadwalLiquid', 'jadwal_liquid_id', 'id');
    }

}