<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQualificationsTable extends Migration {

	public function up()
	{
		Schema::create('qualifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('educational_qualification', array(''master'', ''PhD'', ''bachelor'', ''secondary'', ''diploma''));
			$table->string('university_name');
			$table->string('specialization');
			$table->date('graduation_year');
			$table->integer('applied_employee_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('qualifications');
	}
}