<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvestorsTable extends Migration {

	public function up()
	{
		Schema::create('investors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('investor_group_id');
			$table->integer('iban_id');
			$table->decimal('balance', 20,2)->default('0');
			$table->decimal('initial_balance', 20,2)->default('0');
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('investors');
	}
}