<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChancesTable extends Migration {

	public function up()
	{
		Schema::create('chances', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title_ar');
			$table->string('title_en');
			$table->text('description_ar');
			$table->text('description_en');
			$table->tinyInteger('status');
			$table->tinyInteger('active');
			$table->tinyInteger('publish')->default('0');
			$table->integer('category_id');
			$table->integer('risk_id');
			$table->decimal('requested_amount', 20,2);
			$table->decimal('amount', 20,2);
		});
	}

	public function down()
	{
		Schema::drop('chances');
	}
}