<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JuryCandidacy extends Model 
{

    protected $table = 'jury_candidacies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function candidacy()
    {
        return $this->hasMany('Candidacy', 'candidacy_id');
    }

    public function jury()
    {
        return $this->hasMany('Jury', 'jury_id');
    }

}