<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Candidacy extends Model 
{

    protected $table = 'candidacies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function applicant()
    {
        return $this->hasOne('Applicant', 'applicant_id');
    }

    public function agent()
    {
        return $this->hasOne('Agent', 'agent_id');
    }

    public function third()
    {
        return $this->hasOne('Third', 'third_id');
    }

    public function offer()
    {
        return $this->hasOne('Offer', 'offer_id');
    }

}