<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Candidacy extends Eloquent {

	protected $table = 'candidacies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function applicant()
	{
		return $this->hasOne('Applicant', 'applicant_id');
	}

	public function agent()
	{
		return $this->hasOne('Agent', 'agent_id');
	}

	public function third()
	{
		return $this->hasOne('Third', 'third_id');
	}

	public function offer()
	{
		return $this->hasOne('Offer', 'offer_id');
	}

}