<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vendor extends Eloquent {

	protected $table = 'vendor';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'name_en', 'name_ar', 'phone', 'email', 'website', 'longitude', 'latitude', 'description_en', 'description_ar', 'commission_rate');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function services()
	{
		return $this->belongsToMany('Service', 'vendor_service', 'service_id', 'vendor_id');
	}

	public function categories()
	{
		return $this->belongsToMany('Category', 'vendor_category', 'category_id', 'vendor_id');
	}

}