<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceCategory extends Eloquent {

	protected $table = 'service_category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'service_id');

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}