<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Address extends Eloquent {

	protected $table = 'address';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'name', 'city', 'address', 'longitude', 'latitude', 'phone_number', 'is_primary');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}