<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalTable extends Migration {

	public function up()
	{
		Schema::create('medical', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('patient_id')->nullable();
			$table->integer('medical_question_id')->nullable();
			$table->enum('answer', array('yes', 'no'))->nullable();
			$table->text('answers')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('medical');
	}
}