<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTable extends Migration {

	public function up()
	{
		Schema::create('payment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('order_id')->nullable();
			$table->string('transaction_id')->nullable();
			$table->double('amount')->nullable();
			$table->string('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment');
	}
}