<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model 
{

    protected $table = 'ticket';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title_en', 'title_ar', 'message_en', 'message_ar', 'status', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}