<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;

class Schedule extends Model 
{

    protected $table = 'schedule';
    public $timestamps = true;
    protected $fillable = array('vendor_id', 'service_id', 'time_from', 'time_to', 'duration');

    public function Service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function Vendor()
    {
        return $this->belongsTo('Vendor', 'vendor_id');
    }

}