<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;

class Message extends Model 
{

    protected $table = 'message';
    public $timestamps = true;
    protected $fillable = array('order_id', 'user_id', 'staff_id', 'last_message');

    public function Order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function User()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function Staff()
    {
        return $this->belongsTo('User', 'staff_id');
    }

}