<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;

class Lifestyle extends Model 
{

    protected $table = 'lifestyle';
    public $timestamps = true;
    protected $fillable = array('patient_id', 'lifestyle_question_id', 'lifestyle_answer_id');

    public function LifestyleQuestion()
    {
        return $this->belongsTo('LifestyleQuestion', 'lifestyle_question_id');
    }

    public function LifestyleAnswer()
    {
        return $this->belongsTo('LifestyleAnswer', 'lifestyle_answer_id');
    }

    public function Patient()
    {
        return $this->belongsTo('Patient', 'patient_id');
    }

}