<?php

namespace UserVoucherType;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserVoucherType extends Eloquent {

	protected $table = 'user_voucher_types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User', 'userable');
	}

	public function type()
	{
		return $this->belongsTo('VoucherType', 'voucher_type_id');
	}

}