<?php

namespace LegalInstructionsTranslation;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LegalInstructionsTranslation extends Eloquent {

	protected $table = 'legal_instructions_translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

	public function legalInstruction()
	{
		return $this->belongsTo('LegalInstruction', 'legal_instruction_id');
	}

}