<?php

namespace FaqTypeTranslation;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FaqTypeTranslation extends Eloquent {

	protected $table = 'faq_types_translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

	public function faqType()
	{
		return $this->belongsTo('FaqType', 'faq_type_id');
	}

}