<?php

namespace EmitentContentTranslation;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmitentContentTranslation extends Eloquent {

	protected $table = 'emitent_content_translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

	public function emitent()
	{
		return $this->belongsTo('EmitentContent', 'emitent_content_id');
	}

}