<?php

namespace EmitentContent;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmitentContent extends Eloquent {

	protected $table = 'emitent_content';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function images()
	{
		return $this->morphMany('Image', 'imageable');
	}

	public function emitent()
	{
		return $this->belongsTo('Emitent', 'emitent_id');
	}

}