<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('emitents', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emitents', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('emitent_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_entities', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('physical_entities', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('voucher_types', function(Blueprint $table) {
			$table->foreign('visibility_id')->references('id')->on('visibilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('emitent_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('user_voucher_type_id')->references('id')->on('user_voucher_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('voucher_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('apoens', function(Blueprint $table) {
			$table->foreign('voucher_id')->references('id')->on('vouchers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_vouchers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_vouchers', function(Blueprint $table) {
			$table->foreign('voucher_id')->references('id')->on('vouchers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_voucher_types', function(Blueprint $table) {
			$table->foreign('voucher_type_id')->references('id')->on('voucher_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_voucher_types', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emitent_content', function(Blueprint $table) {
			$table->foreign('emitent_id')->references('id')->on('emitents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('news_translations', function(Blueprint $table) {
			$table->foreign('news_id')->references('id')->on('news')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('news_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('testemonials_translations', function(Blueprint $table) {
			$table->foreign('testemonial_id')->references('id')->on('testemonials')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('testemonials_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('testemonials')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emitent_content_translations', function(Blueprint $table) {
			$table->foreign('emitent_content_id')->references('id')->on('emitent_content')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emitent_content_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emitent_categories_translations', function(Blueprint $table) {
			$table->foreign('emitent_category_id')->references('id')->on('emitent_categories_translations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emitent_categories_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emitent_categories_translations', function(Blueprint $table) {
			$table->foreign('emitent_category')->references('id')->on('emitent_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities_translations', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('countries_translations', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('countries_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('homepage_cards_translations', function(Blueprint $table) {
			$table->foreign('homepage_card_id')->references('id')->on('homepage_cards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('homepage_cards_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->foreign('faq_type_id')->references('id')->on('faq_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faqs_translations', function(Blueprint $table) {
			$table->foreign('faq_id')->references('id')->on('faqs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faqs_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faq_types_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faq_types_translations', function(Blueprint $table) {
			$table->foreign('faq_type_id')->references('id')->on('faq_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_instructions_translations', function(Blueprint $table) {
			$table->foreign('legal_instruction_id')->references('id')->on('legal_instructions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_instructions_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('physical_insts_translations', function(Blueprint $table) {
			$table->foreign('physical_instruction_id')->references('id')->on('physical_instructions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('physical_insts_translations', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('emitents', function(Blueprint $table) {
			$table->dropForeign('emitents_city_id_foreign');
		});
		Schema::table('emitents', function(Blueprint $table) {
			$table->dropForeign('emitents_category_id_foreign');
		});
		Schema::table('legal_entities', function(Blueprint $table) {
			$table->dropForeign('legal_entities_city_id_foreign');
		});
		Schema::table('physical_entities', function(Blueprint $table) {
			$table->dropForeign('physical_entities_city_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('voucher_types', function(Blueprint $table) {
			$table->dropForeign('voucher_types_visibility_id_foreign');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_emitent_id_foreign');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_user_voucher_type_id_foreign');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_status_id_foreign');
		});
		Schema::table('apoens', function(Blueprint $table) {
			$table->dropForeign('apoens_voucher_id_foreign');
		});
		Schema::table('user_vouchers', function(Blueprint $table) {
			$table->dropForeign('user_vouchers_user_id_foreign');
		});
		Schema::table('user_vouchers', function(Blueprint $table) {
			$table->dropForeign('user_vouchers_voucher_id_foreign');
		});
		Schema::table('user_voucher_types', function(Blueprint $table) {
			$table->dropForeign('user_voucher_types_voucher_type_id_foreign');
		});
		Schema::table('user_voucher_types', function(Blueprint $table) {
			$table->dropForeign('user_voucher_types_user_id_foreign');
		});
		Schema::table('emitent_content', function(Blueprint $table) {
			$table->dropForeign('emitent_content_emitent_id_foreign');
		});
		Schema::table('news_translations', function(Blueprint $table) {
			$table->dropForeign('news_translations_news_id_foreign');
		});
		Schema::table('news_translations', function(Blueprint $table) {
			$table->dropForeign('news_translations_language_id_foreign');
		});
		Schema::table('testemonials_translations', function(Blueprint $table) {
			$table->dropForeign('testemonials_translations_testemonial_id_foreign');
		});
		Schema::table('testemonials_translations', function(Blueprint $table) {
			$table->dropForeign('testemonials_translations_language_id_foreign');
		});
		Schema::table('emitent_content_translations', function(Blueprint $table) {
			$table->dropForeign('emitent_content_translations_emitent_content_id_foreign');
		});
		Schema::table('emitent_content_translations', function(Blueprint $table) {
			$table->dropForeign('emitent_content_translations_language_id_foreign');
		});
		Schema::table('emitent_categories_translations', function(Blueprint $table) {
			$table->dropForeign('emitent_categories_translations_emitent_category_id_foreign');
		});
		Schema::table('emitent_categories_translations', function(Blueprint $table) {
			$table->dropForeign('emitent_categories_translations_language_id_foreign');
		});
		Schema::table('emitent_categories_translations', function(Blueprint $table) {
			$table->dropForeign('emitent_categories_translations_emitent_category_foreign');
		});
		Schema::table('cities_translations', function(Blueprint $table) {
			$table->dropForeign('cities_translations_city_id_foreign');
		});
		Schema::table('cities_translations', function(Blueprint $table) {
			$table->dropForeign('cities_translations_language_id_foreign');
		});
		Schema::table('countries_translations', function(Blueprint $table) {
			$table->dropForeign('countries_translations_country_id_foreign');
		});
		Schema::table('countries_translations', function(Blueprint $table) {
			$table->dropForeign('countries_translations_language_id_foreign');
		});
		Schema::table('homepage_cards_translations', function(Blueprint $table) {
			$table->dropForeign('homepage_cards_translations_homepage_card_id_foreign');
		});
		Schema::table('homepage_cards_translations', function(Blueprint $table) {
			$table->dropForeign('homepage_cards_translations_language_id_foreign');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->dropForeign('faqs_faq_type_id_foreign');
		});
		Schema::table('faqs_translations', function(Blueprint $table) {
			$table->dropForeign('faqs_translations_faq_id_foreign');
		});
		Schema::table('faqs_translations', function(Blueprint $table) {
			$table->dropForeign('faqs_translations_language_id_foreign');
		});
		Schema::table('faq_types_translations', function(Blueprint $table) {
			$table->dropForeign('faq_types_translations_language_id_foreign');
		});
		Schema::table('faq_types_translations', function(Blueprint $table) {
			$table->dropForeign('faq_types_translations_faq_type_id_foreign');
		});
		Schema::table('legal_instructions_translations', function(Blueprint $table) {
			$table->dropForeign('legal_instructions_translations_legal_instruction_id_foreign');
		});
		Schema::table('legal_instructions_translations', function(Blueprint $table) {
			$table->dropForeign('legal_instructions_translations_language_id_foreign');
		});
		Schema::table('physical_insts_translations', function(Blueprint $table) {
			$table->dropForeign('physical_insts_translations_physical_instruction_id_foreign');
		});
		Schema::table('physical_insts_translations', function(Blueprint $table) {
			$table->dropForeign('physical_insts_translations_language_id_foreign');
		});
	}
}