<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOwnersTable extends Migration {

	public function up()
	{
		Schema::create('owners', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('country_key');
			$table->string('phone');
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('password');
			$table->string('avatar', 255)->default('default.png');
			$table->string('rate', 255);
			$table->double('wallet', 100)->default('0,0');
		});
	}

	public function down()
	{
		Schema::drop('owners');
	}
}