<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAddressDetailsTable extends Migration {

	public function up()
	{
		Schema::create('user_address_details', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('billing', 'shipping'));
			$table->bigInteger('user_id');
			$table->boolean('is_current');
			$table->string('house_no');
			$table->string('address_line_1');
			$table->string('address_line_2');
			$table->string('city');
			$table->string('country');
			$table->string('district');
			$table->string('zip');
			$table->string('latitude');
			$table->string('longitude');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_address_details');
	}
}