<?php

namespace Product;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Author()
	{
		return $this->belongsTo('User\User', 'user_id');
	}

	public function metaData()
	{
		return $this->morphMany('Meta\Meta', 'meta_model');
	}

}