<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title')->nullable();
			$table->float('amount')->nullable();
			$table->integer('owner_id')->unsigned();
			$table->integer('organisation_id')->unsigned();
			$table->string('short_url')->nullable();
			$table->timestamp('sent_at')->nullable();
			$table->enum('status', array('concept', 'verstuurd', 'gearchiveerd'));
			$table->enum('stage', array('open', 'gewonnen', 'verloren'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}