<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->longText('content');
			$table->string('slug')->unique();
			$table->string('image')->nullable();
			$table->integer('categorie_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->boolean('online')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}