<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class District extends Eloquent {

	protected $table = 'districts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'is_active', 'city_id');

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function communities()
	{
		return $this->hasMany('Community');
	}

	public function buildings()
	{
		return $this->morphMany('Building', 'model');
	}

	public function units()
	{
		return $this->morphMany('Unit', 'model');
	}

}